/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.FluidDrainerBlock;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.ConfigurableUpgradableInventoryFluidEnergyStorageBlockEntity;
import me.jddev0.ep.block.entity.base.FluidStorageSingleTankMethods;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergizedPowerLimitingEnergyStorage;
import me.jddev0.ep.fluid.SimpleFluidStorage;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.inventory.data.ComparatorModeValueContainerData;
import me.jddev0.ep.inventory.data.FluidValueContainerData;
import me.jddev0.ep.inventory.data.RedstoneModeValueContainerData;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.screen.FluidDrainerMenu;
import me.jddev0.ep.util.FluidUtils;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3913;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidDrainerBlockEntity
extends ConfigurableUpgradableInventoryFluidEnergyStorageBlockEntity<EnergizedPowerEnergyStorage, class_1277, SimpleFluidStorage> {
    public static final long MAX_FLUID_DRAINING_PER_TICK = ModConfigs.COMMON_FLUID_DRAINER_FLUID_ITEM_TRANSFER_RATE.getValue();
    public static final long ENERGY_USAGE_PER_TICK = ModConfigs.COMMON_FLUID_DRAINER_ENERGY_CONSUMPTION_PER_TICK.getValue();
    final InputOutputItemHandler itemHandlerSided;
    private long fluidDrainingLeft;
    private long fluidDrainingSumPending;
    private boolean forceAllowStackUpdateFlag;

    public FluidDrainerBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(EPBlockEntities.FLUID_DRAINER_ENTITY, blockPos, blockState, "fluid_drainer", ModConfigs.COMMON_FLUID_DRAINER_CAPACITY.getValue(), ModConfigs.COMMON_FLUID_DRAINER_TRANSFER_RATE.getValue(), 1, FluidStorageSingleTankMethods.INSTANCE, FluidUtils.convertMilliBucketsToDroplets(ModConfigs.COMMON_FLUID_DRAINER_FLUID_TANK_CAPACITY.getValue() * 1000L), UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
        this.itemHandlerSided = new InputOutputItemHandler((class_1263)this.itemHandler, (i, stack) -> true, i -> {
            if (i != 0) {
                return false;
            }
            class_1799 itemStack = this.itemHandler.method_5438(i.intValue());
            if (ContainerItemContext.withConstant((class_1799)itemStack).find(FluidStorage.ITEM) == null) {
                return true;
            }
            Storage fluidStorage = (Storage)FluidStorage.ITEM.find(itemStack, (Object)ContainerItemContext.ofSingleSlot((SingleSlotStorage)((SingleSlotStorage)InventoryStorage.of((class_1263)this.itemHandler, null).getSlots().get((int)i))));
            if (fluidStorage == null) {
                return true;
            }
            if (!fluidStorage.supportsExtraction()) {
                return true;
            }
            for (StorageView fluidView : fluidStorage) {
                FluidVariant fluidVariant = (FluidVariant)fluidView.getResource();
                if (fluidVariant.isBlank() || !((SimpleFluidStorage)this.fluidStorage).isEmpty() && !fluidVariant.equals((Object)((SimpleFluidStorage)this.fluidStorage).getResource())) continue;
                return false;
            }
            return true;
        });
        this.fluidDrainingLeft = -1L;
        this.fluidDrainingSumPending = 0L;
        this.forceAllowStackUpdateFlag = false;
    }

    @Override
    protected EnergizedPowerEnergyStorage initEnergyStorage() {
        return new EnergizedPowerEnergyStorage(this.baseEnergyCapacity, this.baseEnergyCapacity, this.baseEnergyCapacity){

            @Override
            public long getCapacity() {
                return Math.max(1L, (long)Math.ceil((double)this.capacity * FluidDrainerBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            protected void onFinalCommit() {
                FluidDrainerBlockEntity.this.method_5431();
                FluidDrainerBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected EnergizedPowerLimitingEnergyStorage initLimitingEnergyStorage() {
        return new EnergizedPowerLimitingEnergyStorage(this.energyStorage, this.baseEnergyTransferRate, 0L){

            @Override
            public long getMaxInsert() {
                return Math.max(1L, (long)Math.ceil((double)this.maxInsert * FluidDrainerBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }
        };
    }

    @Override
    protected class_1277 initInventoryStorage() {
        return new class_1277(this.slotCount){

            public int method_5444() {
                return 1;
            }

            public boolean method_5437(int slot, class_1799 stack) {
                if (slot == 0) {
                    return ContainerItemContext.withConstant((class_1799)stack).find(FluidStorage.ITEM) != null;
                }
                return super.method_5437(slot, stack);
            }

            public void method_5447(int slot, class_1799 stack) {
                if (slot == 0) {
                    class_1799 itemStack = this.method_5438(slot);
                    if (!(FluidDrainerBlockEntity.this.forceAllowStackUpdateFlag || stack.method_7960() || itemStack.method_7960() || class_1799.method_7984((class_1799)stack, (class_1799)itemStack) && (class_1799.method_31577((class_1799)stack, (class_1799)itemStack) || ContainerItemContext.withConstant((class_1799)stack).find(FluidStorage.ITEM) != null && ContainerItemContext.withConstant((class_1799)itemStack).find(FluidStorage.ITEM) != null))) {
                        FluidDrainerBlockEntity.this.resetProgress();
                    }
                }
                super.method_5447(slot, stack);
            }

            public void method_5431() {
                super.method_5431();
                FluidDrainerBlockEntity.this.method_5431();
            }
        };
    }

    @Override
    protected SimpleFluidStorage initFluidStorage() {
        return new SimpleFluidStorage(this.baseTankCapacity){

            protected void onFinalCommit() {
                FluidDrainerBlockEntity.this.method_5431();
                FluidDrainerBlockEntity.this.syncFluidToPlayers(32);
            }
        };
    }

    @Override
    protected class_3913 initContainerData() {
        return new CombinedContainerData(new FluidValueContainerData(() -> this.fluidDrainingLeft, value -> {}), new FluidValueContainerData(() -> this.fluidDrainingSumPending, value -> {}), new RedstoneModeValueContainerData(() -> this.redstoneMode, value -> {
            this.redstoneMode = value;
        }), new ComparatorModeValueContainerData(() -> this.comparatorMode, value -> {
            this.comparatorMode = value;
        }));
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        this.syncEnergyToPlayer(player);
        this.syncFluidToPlayer(player);
        return new FluidDrainerMenu(id, this, inventory, (class_1263)this.itemHandler, this.upgradeModuleInventory, this.data);
    }

    @Override
    protected void method_11007(@NotNull class_2487 nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 registries) {
        super.method_11007(nbt, registries);
        FluidUtils.writeFluidAmountInMilliBucketsWithLeftover(this.fluidDrainingLeft, "recipe.fluid_draining_left", "recipe.fluid_draining_left_leftover_droplets", nbt);
        FluidUtils.writeFluidAmountInMilliBucketsWithLeftover(this.fluidDrainingSumPending, "recipe.fluid_draining_sum_pending", "recipe.fluid_draining_sum_pending_leftover_droplets", nbt);
    }

    @Override
    protected void method_11014(@NotNull class_2487 nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 registries) {
        super.method_11014(nbt, registries);
        this.fluidDrainingLeft = FluidUtils.readFluidAmountInMilliBucketsWithLeftover("recipe.fluid_draining_left", "recipe.fluid_draining_left_leftover_droplets", nbt);
        this.fluidDrainingSumPending = FluidUtils.readFluidAmountInMilliBucketsWithLeftover("recipe.fluid_draining_sum_pending", "recipe.fluid_draining_sum_pending_leftover_droplets", nbt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, FluidDrainerBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.method_11654((class_2769)FluidDrainerBlock.POWERED))) {
            return;
        }
        if (blockEntity.hasRecipe()) {
            class_1799 itemStack = blockEntity.itemHandler.method_5438(0);
            long fluidDrainingSum = 0L;
            long fluidDrainingLeftSum = 0L;
            if (((SimpleFluidStorage)blockEntity.fluidStorage).getCapacity() - ((SimpleFluidStorage)blockEntity.fluidStorage).getAmount() - blockEntity.fluidDrainingSumPending <= 0L) {
                return;
            }
            long energyConsumptionPerTick = Math.max(1L, (long)Math.ceil((double)ENERGY_USAGE_PER_TICK * blockEntity.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CONSUMPTION)));
            if (((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount() < energyConsumptionPerTick) {
                return;
            }
            if (ContainerItemContext.withConstant((class_1799)itemStack).find(FluidStorage.ITEM) == null) {
                return;
            }
            Storage fluidStorage = (Storage)FluidStorage.ITEM.find(itemStack, (Object)ContainerItemContext.ofSingleSlot((SingleSlotStorage)((SingleSlotStorage)InventoryStorage.of((class_1263)blockEntity.itemHandler, null).getSlots().get(0))));
            if (fluidStorage == null) {
                return;
            }
            FluidVariant firstNonEmptyFluidVariant = FluidVariant.blank();
            for (StorageView fluidView : fluidStorage) {
                FluidVariant fluidVariant = (FluidVariant)fluidView.getResource();
                if (!fluidVariant.isBlank() && firstNonEmptyFluidVariant.isBlank()) {
                    firstNonEmptyFluidVariant = fluidVariant;
                }
                if (fluidVariant.isBlank() || (!((SimpleFluidStorage)blockEntity.fluidStorage).isEmpty() || !fluidVariant.equals((Object)firstNonEmptyFluidVariant)) && !fluidVariant.equals((Object)((SimpleFluidStorage)blockEntity.fluidStorage).getResource())) continue;
                fluidDrainingSum += Math.min(((SimpleFluidStorage)blockEntity.fluidStorage).getCapacity() - ((SimpleFluidStorage)blockEntity.fluidStorage).getAmount() - blockEntity.fluidDrainingSumPending - fluidDrainingSum, Math.min(fluidView.getAmount(), FluidUtils.convertMilliBucketsToDroplets(MAX_FLUID_DRAINING_PER_TICK) - fluidDrainingSum));
                fluidDrainingLeftSum += fluidView.getAmount();
            }
            if (firstNonEmptyFluidVariant.isBlank() || fluidDrainingSum == 0L) {
                return;
            }
            blockEntity.fluidDrainingLeft = fluidDrainingLeftSum;
            blockEntity.fluidDrainingSumPending += fluidDrainingSum;
            blockEntity.forceAllowStackUpdateFlag = true;
            try (Transaction transaction = Transaction.openOuter();){
                ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).extract(energyConsumptionPerTick, (TransactionContext)transaction);
                long fluidSumDrainable = Math.min(((SimpleFluidStorage)blockEntity.fluidStorage).getCapacity() - ((SimpleFluidStorage)blockEntity.fluidStorage).getAmount(), blockEntity.fluidDrainingSumPending);
                FluidVariant fluidVariantToDrain = ((SimpleFluidStorage)blockEntity.fluidStorage).isEmpty() ? firstNonEmptyFluidVariant : (FluidVariant)((SimpleFluidStorage)blockEntity.fluidStorage).getResource();
                long fluidSumDrained = fluidStorage.extract((Object)fluidVariantToDrain, fluidSumDrainable, (TransactionContext)transaction);
                if (fluidSumDrained > 0L) {
                    ((SimpleFluidStorage)blockEntity.fluidStorage).insert((TransferVariant)fluidVariantToDrain, fluidSumDrained, (TransactionContext)transaction);
                    blockEntity.fluidDrainingSumPending -= fluidSumDrained;
                    blockEntity.fluidDrainingLeft = fluidDrainingLeftSum - fluidSumDrained;
                }
                transaction.commit();
            }
            finally {
                blockEntity.forceAllowStackUpdateFlag = false;
            }
            if (blockEntity.fluidDrainingLeft <= 0L) {
                blockEntity.resetProgress();
            }
            FluidDrainerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        } else {
            blockEntity.resetProgress();
            FluidDrainerBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        }
    }

    private void resetProgress() {
        this.fluidDrainingLeft = -1L;
        this.fluidDrainingSumPending = 0L;
    }

    private boolean hasRecipe() {
        class_1799 itemStack = this.itemHandler.method_5438(0);
        if (ContainerItemContext.withConstant((class_1799)itemStack).find(FluidStorage.ITEM) != null) {
            Storage fluidStorage = (Storage)FluidStorage.ITEM.find(itemStack, (Object)ContainerItemContext.ofSingleSlot((SingleSlotStorage)((SingleSlotStorage)InventoryStorage.of((class_1263)this.itemHandler, null).getSlots().get(0))));
            if (fluidStorage == null) {
                return false;
            }
            for (StorageView fluidView : fluidStorage) {
                FluidVariant fluidVariant = (FluidVariant)fluidView.getResource();
                if (fluidVariant.isBlank() || !((SimpleFluidStorage)this.fluidStorage).isEmpty() && !fluidVariant.equals((Object)((SimpleFluidStorage)this.fluidStorage).getResource())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void updateUpgradeModules() {
        this.resetProgress();
        super.updateUpgradeModules();
    }
}

